ScriptName RF:DisasterScript Extends Quest
; This handles our explosion system as well as any future difficuly systems

RF:FuelHandlerQuest Property FuelManager Auto Mandatory Const
RF:TravelHandlerQuest Property TravelManager Auto Mandatory Const
RF:TutorialQuest Property TutorialManager Mandatory Const Auto

ActorValue Property SpaceshipShieldHealth Auto Mandatory Const
{ In default mode we cannot trigger explosion without shields depleted }
ActorValue Property Carryweight Mandatory Const Auto
{ We are currently using simply a % of total cargo to determine if roll goes or not }

Spell Property _RF_GravDriveOverheatSpell Mandatory Const Auto
{ We can also trigger an immediate failure via this - convenient! }

MiscObject property InorgCommonHelium3 auto const mandatory

FormList Property _RF_LIST_ProjMissile Mandatory Const Auto
{ This is imported to an array to check OnHit() }
FormList Property _RF_LIST_ProjBallistic Mandatory Const Auto

ConditionForm[] Property PayloadsRanks Mandatory Const Auto
{ 0-4 for ranks to influence dice roll }
ConditionForm[] Property ShieldSystemsRanks Mandatory Const Auto
{ 0-4 for ranks to influence dice roll }

WwiseEvent Property ExplosionSoundSevere Mandatory Const Auto
{ These are extremely serious events and need a lot of feedback }
WwiseEvent Property KlaxonSoundSevere Mandatory Const Auto
{ These are extremely serious events and need a lot of feedback }

SpaceshipReference MyShip
Actor PlayerRef
ActorValue Hull

bool Running = false
bool Hardcore = false

int DangerFill = 50

int Payloads = 0
int ShieldSystems = 0
int HeliumFill = 0 ; Filled in HandleDisaster
bool RecentEvent = false

Form[] MissileArray
Projectile[] BallisticArray

bool DEBUGON = true ; Only for logging in this system
bool DEBUGNOTIFY = false ; I want to see what's going on for this one
bool DEBUGFORCE = false ; Always trigger event. DISABLE FOR PROD!


;----------------------------------------------------
;----------------- DEBUG AND SYSTEM ----------------- 
;----------------------------------------------------


; Generic debug function that can be disabled for prod
Function DBG(String asTextToPrint = "Debug Error!")
    If DEBUGON
        Debug.Trace("RF Disaster: " + asTextToPrint)
        IF DEBUGNOTIFY ; Can log in realtime to avoid alt-tabbing constantly
            Debug.Notification("RDSTR: " + asTextToPrint)
        EndIF
    EndIF
EndFunction

; Weight adds to our chance of winning. Save indicates above what int we will pass the check
bool Function DieRoll(int aiWeight = 0, int aiSave = 50)
    bool Heads = true
    int TheRoll = Utility.RandomInt(0, 100) + aiWeight
    If TheRoll <= aiSave
        Heads = false
    EndIf
    Return Heads
EndFunction

; Return the value of MyShip or TheShip
float Function GV(ActorValue akValue, SpaceshipReference akTheShip = None)
    float Value = 1.0
    IF akTheShip
        Value = akTheShip.GetValue(akValue)
    Else
        Value = Myship.GetValue(akValue)
    EndIf
    Return Value
EndFunction

; Return the value % as int of MyShip or TheShip with optional rounding to tens
int Function GVPCT(ActorValue akValue, bool abModTens = false, SpaceshipReference akTheShip = None)
    SpaceshipReference ShipToCheck
    int Percent = 42
    If akTheShip
        ShipToCheck = akTheShip
    Else
        ShipToCheck = MyShip
    EndIF
    float Base = GBV(akValue, ShipToCheck)
    float Now = GV(akValue, ShipToCheck)
    Percent = Math.Round( Now / Base )
    If abModTens
        Percent += ( 10 - ( Percent % 10 ) )
    EndIF
    Return Percent
EndFunction

; Return the base value of Myship or TheShip
float function GBV(ActorValue akValue, SpaceshipReference akTheShip = None)
    float Value = 2.0
    IF akTheShip
        Value = akTheShip.GetBaseValue(akValue)
    Else
        Value = Myship.GetBaseValue(akValue)
    EndIf
    Return Value
EndFunction

; using DamageValueSafe direct from TravelManager

; Returns the % of our total cargo capacity that is taken up by the form
int Function GetCargoFillAmount(Form asFormToCheck)
    float Hold = GV(Carryweight) ; Get our total hold capacity
    float ItemWeight = asFormToCheck.GetWeight()
    int ItemCount = MyShip.GetItemCount(asFormToCheck)
    float ItemTotalMass = ItemCount * ItemWeight ; Thank god for Form.GetWeight()!
    int Percent = Math.Floor( ItemTotalMass / Hold )
    DBG("GCFA got Capacity: " + Hold + " at " + Percent + "% full for " + ItemCount + " " + asFormToCheck + " at " + ItemWeight + " per item ")
    Return Percent
EndFunction

; True indicates all elements of Travel are running
bool Function DamageSystemEnabled()
    If !FuelManager.ModRunning()
        If Running
            Debug.Notification("Damage system shutting down.")
        EndIf
        Running = False
        DBG("Disaster system shutdown")
    Else ; For now we are just hooking this up to the main system. Hardcore will be separate
        If !Running
            ;Debug.Notification("Damage system enabled.")
        EndIF
        Running = True
        DBG("Disaster system running")
    EndIf
    return Running
EndFunction

bool Function DamageSystemRunning()
    Return Running
EndFunction

;This just refills our ints, no return val
Function CheckSkills()
    int i = 0
    While i < PayloadsRanks.length
        If PayloadsRanks[i].IsTrue(PlayerRef)
            Payloads = i
            DBG("Payloads: " + i)
        EndIf
        i += 1
    EndWhile
    i = 0
    While i < ShieldSystemsRanks.length
        If ShieldSystemsRanks[i].IsTrue(PlayerRef)
            ShieldSystems = i
            DBG("Shield Systems: " + i)
        EndIf
        i += 1
    EndWhile
EndFunction

; True will unregister, counterintuitively.
Function HitReg(bool abUnRegister = false)
    If !abUnRegister
        ;DBG("HitReg Registering for hit")
        RegisterForHitEvent(MyShip)
    Else
        DBG("HitReg UnRegistering for hit")
        UnRegisterForHitEvent(MyShip)
    EndIf
EndFunction

; I need to set up logic for container counting in here
; set afMax to something like 1.5 for ballistic, leave at 4 for missile impacts
Function HandleHeliumLoss(float afMaxModulesDestroyed = 4.0)
    float CW = GV(Carryweight)
    int AverageCargoCap = 80 ; I need to check game files for this and maybe scale on total ship mass
    int EstimatedCargoModules = Math.Round( CW / AverageCargoCap )
    float PayloadMult = ( Payloads * 0.2 ) ; Good storage practices prevent accidents!
    int ModulesDestroyed = Math.Round( Utility.RandomFloat(1.0, afMaxModulesDestroyed) - PayloadMult ) ; maybe scale this on missiles vs ballistic?
    int HeliumLost = Math.Round( ( AverageCargoCap * ModulesDestroyed ) * Utility.RandomFloat(0.7, 0.9) ) ; lose 70-90% of each simulated module
    DBG("HandleHeliumLoss exploded " + HeliumLost + " from derived modules " + ModulesDestroyed + " and total " + CW)
    ForceJettisonAmount(InorgCommonHelium3, HeliumLost)
EndFunction

; Remove a percent of the amount in our hold of a form
Function ForceJettisonPercent(Form asFormtoRemove, float afAmount = 0.5)
    int AmountInHold = MyShip.GetItemCount(asFormtoRemove)
    int AmountToDrop = Math.Ceiling( AmountInHold * afAmount )
    MyShip.RemoveItem(asFormtoRemove, AmountToDrop, true)
    DBG("ForceJettisonPercent removed " + AmountToDrop + " of " + asFormtoRemove + " at " + afAmount + "%")
EndFunction

Function ForceJettisonAmount(Form asFormToRemove, int aiAmountRemoved = 1)
    MyShip.RemoveItem(asFormtoRemove, aiAmountRemoved, true)
    DBG("ForceJettisonAmount dropped " + aiAmountRemoved + " of " + asFormToRemove)
EndFunction

Function HandleHits(ObjectReference akAggressor, Form akSource, Projectile akProjectile)
    If !RecentEvent
        RecentEvent = True
        If ( HeliumFill > DangerFill ) ; We have enough to start running checks
            DBG("HandleHits progressed due to HeliumFill > DangerFill")
            If GV(SpaceshipShieldHealth) <= 5 ; Not sure how this handles zeroes
                DBG("HandleHits progressed due to ShieldHealth < 5")
                int MissileIndex = ( MissileArray.Find(akSource) >= 0 ) as int ; Note: These register as the source, shots register as the projectile
                bool Missile = MissileIndex
                int BallisticIndex = ( BallisticArray.Find(akProjectile) >= 0 ) as int
                bool Ballistic = BallisticIndex
                DBG("Index counts got M: " + MissileIndex + " B: " + BallisticIndex)
                If Missile || Ballistic ; Hopefully this is fast enough since we don't have keywords
                    DBG("HandleHits progressed due to Found Form / Projectile")
                    int SaveRollBoost = ( Payloads + ShieldSystems ) * 3 ; caps at 24 for a base 30% die roll - seems fair 
                    bool ResistedDamage = DieRoll(SaveRollBoost, 30)
                    DBG( "Found projectile in array M: " + Missile + " B: " + Ballistic + " and rolled " + ResistedDamage)
                    If !ResistedDamage ; Fun part
                        DBG("HandleHits progressed due to Failed Roll")
                        float DamageType = 4.0
                        If Ballistic
                            DamageType = 1.5
                        EndIF
                        TutorialManager.ShowTutorial(4)
                        ExplosionSoundSevere.Play(PlayerRef) ; Might need an IMOD spell handler for this actually
                        float HullDam = 0.15 * DamageType
                        TravelManager.DamageValueSafe(Hull, HullDam) ; scale this too - it's free immersion!
                        HandleHeliumLoss(DamageType)
                        Utility.Wait(3)
                        _RF_GravDriveOverheatSpell.Cast(PlayerRef)
                        KlaxonSoundSevere.Play(PlayerRef)
                        DBG("EVENT! Triggered damage with " + DamageType )
                    EndIf
                EndIf
            EndIf
        EndIf
    Else
        DBG( "Skipping hit event with RecentEvent " + RecentEvent )
    EndIF
    Utility.Wait(4)
    RecentEvent = False ; Just do a direct Papyrus cooldown, why not
    HitReg()
EndFunction

Function Import1()
    Int listSize = _RF_LIST_ProjMissile.GetSize()
    MissileArray = new Form[listSize]
    Int i = 0
    While i < listSize
        MissileArray[i] = _RF_LIST_ProjMissile.GetAt(i) as Form
        DBG("Imported 1 " + MissileArray[i] + " at index " + i)
        i += 1
    EndWhile
EndFunction

Function Import2()
    Int listSize = _RF_LIST_ProjBallistic.GetSize()
    BallisticArray = new Projectile[listSize]
    Int i = 0
    While i < listSize
        BallisticArray[i] = _RF_LIST_ProjBallistic.GetAt(i) as Projectile
        DBG("Imported 2 " + BallisticArray[i] + " at index " + i)
        i += 1
    EndWhile
EndFunction

Event OnQuestInit()
    StartTimer(12)
EndEvent

Event OnTimer(int aiTimerID)
    PlayerRef = Game.GetPlayer()
    Hull = Game.GetHealthAV()
    MyShip = FuelManager.GetShip("Damage")
    DamageSystemEnabled()
    CheckSkills()
    Import1()
    Import2()
    GetCargoFillAmount(InorgCommonHelium3)
    HitReg()
EndEvent

Function HandleDisasterSystem()
    If Running
        MyShip = FuelManager.GetShip("Damage")
        RecentEvent = False
        If MyShip.IsInSpace() == False ; This won't be doing much on land... no reason to keep it going.
            HitReg(true)
        Else
            HitReg()
        EndIF
    EndIf
EndFunction

Event OnHit(ObjectReference akTarget, ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked, string asMaterialName)
    If Running    
        DBG("Hit triggered from Source: " + akSource + " with Projectile " + akProjectile)
        HeliumFill = GetCargoFillAmount(InorgCommonHelium3)
        HandleHits(akAggressor, akSource, akProjectile)
    Else
        DBG("EXCEPTION - OnHit registered with mod not running")
    EndIF
EndEvent